qui {
noisily {
	/*************************************************/
	/******** Step 1.9. Political (in)stability *****/
	/*************************************************/
	
/*
/* 1.9.1. Military conflict */

To gain panel data on the existence, intensity and duration of military conflict, our strategy is the following:
	- Collect data on the number of battle deaths suffered in each country-year as reported by PRIO & WDI
	- Compute the average number of battle deaths reported in both sources
	- Set battle deaths to 0 if a country-year is not reported to have suffered battle deaths in either PRIO or WDI (cf. assume missings are zeroes)
*/
}

/* 1.9.1.1. Load data */
cd ..
cd ".\3. Intermediary results"
merge 1:1 year cntrycode_PRIO using PRIO, keepusing(bdeaths_PRIO)
drop if _merge == 2
drop _merge
merge 1:1 year cntrycode_WDI using WDI, keepusing(bdeaths_WDI)
drop if _merge == 2
drop _merge
		
/* 1.9.1.2. Compute average battle deaths in both resources */

	* Construct data
	noi di "Correlation between PRIO and WDI reported battle deaths:"
	noi corr bdeaths_PRIO bdeaths_WDI
	scalar correlation_bdeaths_1 = round(`r(rho)',.01)
	egen bdeaths = rowmean(bdeaths_*) if year >= $startyear & independence_years != .
	replace bdeaths = 0 if bdeaths == .

	* Indicate data sources
	gen source_bdeaths = ""
	replace source_bdeaths = source_bdeaths+"1" if bdeaths_PRIO != .
	replace source_bdeaths = source_bdeaths+"2" if bdeaths_WDI != .
	destring source_bdeaths, replace
	bysort cntry: egen source_bdeaths2 = max(source_bdeaths)
	replace source_bdeaths = source_bdeaths2
	drop source_bdeaths2

	* Indicate absence of linear interpolation / extrapolation / polynomial prediction
	gen interpolated_bdeaths = 0 & bdeaths != .
	gen extrapolated_bdeaths = 0  if bdeaths != .
	gen polynomialpredicted_bdeaths = 0  if bdeaths != .

	* Drop raw data
	drop bdeaths_*

/* 1.9.1.4. Compute log and per capita values */
gen lbdeaths = ln(bdeaths+1)
replace bdeaths = bdeaths/pop

noisily {
/* 1.9.2. Macroeconomic (in)stability */
/*
To gain panel data on macroeconomic (in)stability, our strategy is the following:
	- Construct a crisis tally counting the #  currency, inflation, stockmarket, domestic debt, external debt & banking crisis in each year
	- Set missing country-years to 0 (only include known crises)
	- Source: Reinhart & Rogoff
*/
}

/* 1.9.2.1. Load data */
cd ..
cd ".\3. Intermediary results"
merge 1:1 year cntrycode_WDI using RR, keepusing(currency_crisis inflation_crisis stockmarktet_crash domestic_debt_crisis external_debt_crisis banking_crisis)
drop if _merge == 2
drop _merge

/* 1.9.2.2. Compute # crises */

	* Generate crisis tally and dummy indicating crises
	egen crisis_tally = rowtotal(currency_crisis inflation_crisis stockmarktet_crash domestic_debt_crisis external_debt_crisis banking_crisis)
	replace crisis_tally = . if currency_crisis == .
	gen crisis = 1 if crisis_tally > 0 & crisis_tally != .
	
	* Set missings to 0
	replace crisis_tally = 0 if crisis_tally == .
	replace crisis = 0 if crisis == .
	scalar correlation_crisis_1 = 1
	
	* Indicate data sources
	gen source_crisis = 1 if crisis != .

	* Indicate absence of linear interpolation / extrapolation / polynomial prediction
	gen interpolated_crisis = 0 & crisis != .
	gen extrapolated_crisis = 0  if crisis != .
	gen polynomialpredicted_crisis = 0  if crisis != .

	* Drop unnecessary data
	drop currency_crisis inflation_crisis stockmarktet_crash domestic_debt_crisis external_debt_crisis banking_crisis

/* 19.3. Label variables */
label var bdeaths "Battle deaths per head"
label var lbdeaths "Log battle deaths"
label var crisis_tally "# registered currency, inflation, stockmarket, domestic debt, external debt & banking crisis"

/* 1.9.4. Reroute to original folder */
cd ..
cd ".\1. Dofiles"
}
